# 总论

过去三十年，开源以“开放、共享、协同＋商业模式”的新型生产方式，以“自由”的传播形式，成为全球信息技术发展的强大推动力。

近年来，在全世界开源大发展的背景下，中国开源的发展速度为全球最快，其迸发的活力、潜力和惊人的加速度已得到全球开源界的认可，在国际开源事务中的影响力也大幅提升。中国开源局部领域已接近或达到世界先进水平，但发展不平衡的特点也较为明显。与总体发展水平处于第一梯队的美国相比，尚有一定差距，但与发展水平处于第二梯队的西欧、北欧相比，中国开源开始进入该行列。

全球开源正呈现出三个发展阶段：即结合企业、产品与生态的第一阶段；从跨界到融合深度信息技术与应用的第二阶段；建设产业链、供应链实施安全保障的第三阶段。当前，中国开源已进入第二阶段，呈现出开源产品百花齐放、开源技术跨界渗透传统行业的特点，开源的发展使产业界和学术界对共建开源生态有了更深刻的理解和更迫切的追求。从2021年开源被列入国家顶层规划《中华人民共和国国民经济和社会发展第十四个五年规划和2035年远景目标纲要》彰显了政府对开源的重视和支持。

经过政、产、学、研各界的努力，中国开源在社区、基金会、孵化器、代码托管平台，以及教育、开源合规、知识产权保护、风险投资等开源基础设施和支撑体系建设方面，已取得较大进展。但部分环节仍然薄弱，中国开源产业在社区生态、专业化、系统化、应用规模等方面急需加强和完善。如何持续打造开源高地、创新高地、科技高地、人才高地，是中国开源产业的关键课题。

《2022中国开源发展蓝皮书》是在2021年版本基础上，由中国开源软件推进联盟（COPU）牵头，联合中国开发者社区（CSDN）、北京开源创新委员会、开放原子开源基金会、中国电子信息产业发展研究院、中科院软件研究所等85家企业及行业机构、120多位开源专家和志愿者共同协作编撰完成。

为完整呈现2022中国开源产业生态全貌，《2022中国开源发展蓝皮书》从开源基本概念与中国开源历史开始，从九个章节分别介绍了开源基本概念、开源开发者现状、开源项目现状、开源社区现状、开源组织及开源生态现状、开源教育现状、开源商业现状、开源发展机遇与挑战、开源贡献，并对中国开源大事记、开源专有名词、开源人物以附录形式作补充说明。

在《2021中国开源发展蓝皮书》基础上，2022版蓝皮书重点进行了以下几项改进：1）吸引并接纳、扩大了蓝皮书的编组机构和企业团队，以及开源志愿者的团队规模；2）针对中国开源组织和特点，将开源基金会、开源组织、开源生态以独立章节专项展现；3）对开源技术、开源应用趋势进行架构分类和深入介绍；4）附录部分除开源名词外，新增中国开源大事记、开源人物库，并将该部分“知识库”作为蓝皮书长期项目，以开源方式进行长期运营和维护。

希望《2022中国开源发展蓝皮书》能够为广大开源从业者、爱好者、用户，以及开源生态建设者、参与者，全面展现当前中国开源发展的全景图。

## 2022年中国开源发展现状

中国开源可以追溯到20世纪90年代，从Unix进入中国至今，已经历三十余年。从最初的启蒙阶段、萌芽阶段逐步演进到发展阶段，当前中国开源正处于空前的加速阶段。

**一、中国开源在国际开源界的地位和话语权持续提升**

2004年，在政府相关部门指导下，中国开源软件推进联盟（China OSS Promotion Union，缩写 COPU）在北京成立，作为中国第一个专业权威的开源组织首次站在了国际开源舞台上，同一年，发起召开中日韩三国IT局长OSS会议暨东北亚开源软件推进论坛，至今已举办19届。

2006年，中国开源软件推进联盟主办了首届“开源中国开源世界高峰论坛”和“圆桌会议”。自此， 已连续16年作为每年标志性的重要开源活动。伴随首届“开源中国开源世界高峰论坛”和“圆桌会 议”， 中国开源软件推进联盟聘请了世界著名的开源领袖、大师、著名开源基金会主席、跨国企业开 源高管等担任中国开源软件推进联盟智囊团（Think Tank）高级顾问。首届智囊团20人，包括Linux 基金会执行董事 Jim Zemlin；Linux 内核开发大师兼2.6版本监护人 Andrew Morton；Apache 创始人 Brian Behlendorf； MySQL 创始人 David Axmark； Ubuntu 创始人 Mark Shuttleworth；开放源码促 进会 (OSI) 主席 Michael Tiemann；Source Forge 创始人 Larry Augustin；自由软件基金会 (FSF) 的 Eben Moglen； IBM Linux 技术中心 (LTC) 副总裁 Daniel Frye 博士；英特尔开源技术中心 (Intel OTC) 总监 Dirk Hohndel；Jboss 创始人 Marc Fleury；Gnome 基金会 (Gnome Foundation) 主席 Dave Neary等。到今天智囊团已发展到40多人。这是中国开源软件推进联盟很早就创建的开源高地、创新 高地、科技高地、人才高地！

中国开源高地的创立，吸引了全球开源大师、开源组织和机构对中国开源的重视与投入，众多全球 知名开源组织（如Debian、Linux、Apache、FreeBSD、Ubuntu、Mozilla等）及28家跨国公司（包括IBM、HP、Intel、Google、SUN、Oracle、Motorola、Nokia等）等相继申请加入。

多年来，中国开源高地为提高中国开源的话语权，加速中国开源发展、扩大中国开源在世界上的影响，打下了深厚的基础。2008年是中国开源发展史上的重要里程碑，Linux基金会、Gnome基金会、Apache软件基金会及OpenOfﬁce基金会不约而同地选择在中国北京主办相关技术峰会，实现了他们登录亚洲的首秀。2017、2018、2019年，Linux创始人Linus与COPU陆首群主席举行三次炉边谈话，讨论当前国内外开源发展形势和问题。

2021年，Linux基金会执行董事Jim Zemlin在《2021中国开源发展蓝皮书》中评价：中国开源发展很快，如今已接近或达到世界先进水平，一些企业开始进入世界领跑者行列，还涌现出杰出的开源领袖。期望中国在开源的教育、标准化、立法、知识产权保护，以及开源社区、基金会、风险投资等建设方面，基于已取得的较大进步更上一层楼。

2022年，中国开源迎来了新的发展峰值。中国开源开发者、开源项目、开源社区、开源用户数量持续攀升；基金会、知识产权、商业模式、投融资、公共服务平台等开源生态快速完善，尽管其中还有不少待改进和完善处，但中国开源爆发出来的活力、潜力和惊人的加速度已经成为全球开源界的共识，在国际开源界的地位和话语权持续提升。

例如，在国际开源的Kernel.org社区中，中国开发者的内核贡献连续4年霸榜，根据对最新三个版本的统计，中国内核开发者数量是排名第二的德国开发者数量的6.5倍，是排名第三的美国开发者的12倍，来自中国的内核补丁贡献数量约等于第二至第四名之和。在OpenCV社区，中国贡献者正在快速占据主导地位。据2022年OpenCV春季公布的首批OpenCV Area Chair共有9人，其中4名是中国科学家。再例如，芯片明星项目RISC-V在成立之初就备受国人关注。在RISC-V基金会中，理事会中方席位占比达45%；在基金会核心成员（Premier Member）中，中方成员占比达到57.9%；在战略成员（Strategic Member）中，中方成员占比达到26.8%；在社区组织成员（Community Organization Member）中，中方成员占比达到7.6%。

与此同时，在国际顶级开源基金会中，中国开源也表现出强烈的贡献积极性和参与热情。在开源基础设施基金会中，中国成员较2021年同期数量激增26%，达125家，开源基础设施基金会董事会中方成员占比达40.7%；在云原生计算基金会中，超过20%的项目来自中国；在Apache软件基金会中，源自中国的活跃开源项目共24个，其中有14个项目成为了顶级项目，2021年仅有5个进入Apache软件基金会孵化器的新项目全部来自中国；在Linux基金会中，现有中国会员139家，相较于2020年的70家增涨了98.6%……

中国在国际开源的地位和话语权，不能仅由上述数字证明，更多是由数字背后的中国开源人持之以恒的努力和奉献赢得。华为、阿里、百度、腾讯、中兴等11家国内头部科技企业积极投身开源项目贡献与社区治理、生态共建，麒麟软件、统信软件、平凯星辰等7家科创领域新秀也积极开展、参与开源活动，正是每一家企业和学、研机构的积极投入和踊跃参与，才使得中国在世界上的开源贡献度不断攀升。

中国开源的发展也少不了跨国企业的贡献。包括微软、英特尔、IBM、红帽等知名国际技术公司在推动中国开源产业、中国开源项目与技术的发展和应用、开源人才、开源社区发展、开源国际性交流与助力等方面均发挥了非常重要的作用。

**二、中国开源最大的活力来源于数千万的开发者**

2022年，中国开发者数量的增长排名全球第一。开发者对开源项目、活动、社区的投入更加积极，由开发者驱动的中国开源项目陆续登上国际舞台，吸引了全球开发者参与其中，中国本土的开源代码托管平台等基础设施也越来越受到国内开发者的关注与使用。同时，在各个开发者社区，开源话题的热度爆表，吸引着更多开发者和技术内容创作者关注开源，投身开源、创作开源相关的技术内容。

据国内最大开发者社区CSDN统计，中国开发者用户注册数超3500万，2021年增长超700万；中国开发者用户中，超过94%正在使用开源，42%参与过开源项目。根据开源社区Gitee统计，2021年Gitee新增用户数超过了180万，累计超过800万。

GitHub 2021年数据统计，中国开发者数量相较前一年增长103万，增幅为48%，已增至755万，排名全球第二，并贡献了550万个项目。同样，来自CNCF的数据表明，截至2022年2月，CNCF超过20%的开源项目来自中国，中国开发者的贡献度排名上升至世界第二。

据Apache软件基金会2021财年年度报告显示，中国用户访问次数最多。在项目活跃度Top 10中，中国项目IoTDB排名第7、ShardingSphere排名第10，越来越多的中国项目活跃在国际舞台上。在开源领域表现活跃且投入较大的科技公司包括阿里巴巴、腾讯、百度、蚂蚁、滴滴、字节跳动、小米等，同时也有一些基于开源做商业化的初创企业表现活跃，如PingCAP、StreamNative、SphereEx等。

在有关开源的调研分析中，开发者关注热度明显上升的技术方向有大前端与跨平台开发、云原生、大数据、人工智能、开源基础设施（数据库、中间件、RISC-V、ARM 架构）、Web3 与区块链等。另外关于开源项目的安全性，也得到了越来越多企业和技术管理者的重视。

**三、开源项目高速发展，技术与产业协同共进**

2022年，中国开源项目同样处于快速发展的阶段。据有关开源项目的调研分析发现，在数据库、人工智能、云计算、大数据、云原生和前端框架领域，部分中国开源项目已跻身世界前列，在操作系统、物联网、智能网联汽车、开源硬件等方向，中国开源项目正在奋起直追，努力缩小差距，在开发工具、编程语言等基础领域，中国开源项目距离世界领先水平还存在较大差距。与此同时，新一代人工智能、大数据、云计算、工业互联网、区块链等技术领域结合开源，已呈现出技术与产业协同发展的新局面。

华东师范大学对GitHub年度项目进行统计，语言类依然最具活跃度，如Flutter、VS Code等广受欢迎。活跃度排名前三的中国开源项目，分别是百度的PaddlePaddle、蚂蚁的Ant Design和PingCAP的Tidb，榜上有名的中国开源项目团队还包括阿里、腾讯、青云、华为、京东、有赞等。与同类国际开源项目活跃度作横向对比，中国开源项目自身的成熟度、应用领域、全球化、生态建设和项目推广等因素，是制约中国项目在全球流行的主要五个因素。

* 在操作系统领域，开源操作系统发展迅速、数量激增。截至2022年4月，国内已累计涌现出100+种操作系统，它们均基于或参考了开源的操作系统的结构和代码实现，其中华为、阿里、腾讯、小米、中国移动、麒麟软件、统信软件等企业作出了重要贡献，相关项目在国内外引起广泛关注。目前操作系统的边界已经被大大地扩展了。在产业界，中国开源操作系统正努力向国际先进水平靠近，尤其是运行在手机、嵌入式设备以及自动驾驶方向的操作系统研发，已形成了新的产业热点。

* 相比价值已达数百亿美元的开源软件生态，芯片虽已成为支撑各行各业的基石，但开源芯片仍处于起步阶段。在处理器芯片领域，基于开源指令集 RISC-Ⅴ的开源芯片生态正在快速崛起，RISC-V的全球产业生态正在构建中，中国已经成为其中最重要的参与者，并涌现出在RISC-V基础上开放程度更高的“香山”处理器等明星开源项目。清华-伯克利RIOS实验室、中科院计算所、中科院软件所、中国科学院大学、上海交通大学等科研院所，阿里平头哥、华为海思、华米、赛昉科技、芯来科技、睿思芯科等企业在全球RISC-V生态建设过程中发挥着越来越重要的作用。

* 在数据库领域，开源已经成为主要的趋势和潮流。据DB-Engines 的数据显示，自2021年1月，开源数据库的流行度首次超越商业数据库，并持续领先。全球383款数据库中，开源数据库占据51.7%，排名前十的数据库中，开源数据库占据六席。据墨天轮的中国数据库流行度排行榜，198个数据库产品中包含13个开源的数据库产品，而榜单的前十名就有5个开源产品。中国主导的开源数据库排名TOP5的分别是：PingCAP公司的TiDB、百度的Apache Doris、涛思数据的TDengine、悦数科技的Nebula Graph以及鼎石科技的StarRocks。

* 人工智能产业每年以近25%的复合年度增长率快速发展，已经成为世界各国科技创新的旗舰领域，是下一代信息技术的核心，也是科技制高点。相较而言，在计算机视频、语音识别、图形识别、自动驾驶等领域，中国开源有一定的优势；在由可解释性机器学习与神经拟态计算系统统一的强人工智能阶段，中国开始崭露头角。众多开源产品中，百度主导的PaddlePaddle、华为的Mind Spore、旷视的Meg Engine以及一流科技的One Flow等明星项目处于快速发展中，但对比国外同类产品，仍处于追赶阶段。2021年第四范式对机器学习数据库Open MLDB以及AI操作系统内核Open AIOS进行开源。相信随着AI场景化的广泛应用，开源将极大地促进中国AI创新技术与产业的融合应用。

* 云计算如今已是IT业界的主流技术，开源在云原生体系中起到了至关重要的作用，几乎所有的云原生技术，都有开源项目作为其代表实现或主流方案，从某种意义上整个云原生体系是构建在开源上的。近年来国内涌现出一批优秀且成熟的开源云原生项目，具有代表性的有PingCap推出的分布式事务键值数据库TiKV；阿里巴巴的云原生镜像分发系统Dragonfly、分布式内存数据管理引擎Vineyard；京东为大规模容器平台设计的分布式文件系统ChubaoFS；以及由南京大学 PASALab 副研究员顾荣博士、阿里云容器服务高级技术专家车漾、Alluxio 项目创始成员范斌博士联合推动发起的Fluid等等。

* 对于大数据技术而言，拥抱开源一直是主旋律。与全球领先的大数据技术公司如谷歌、微软、IBM、亚马逊等相比，国内的大数据技术起步较晚，但得益于国家发展战略的推动和5G、移动互联、物联网等技术快速发展带来的数据存储量增长，国内大数据产业的支撑得到强化，应用范围加速拓展，产业规模实现快速增长。然而，在大数据管理、处理系统与工具方面，中国主导的开源项目与国际开源社区的影响力仍需提升。

* 隐私计算作为一项可以保障数据流通过程中“原始数据不出域、数据可用不可见”的技术，成为数据要素可信流通的关键技术模式。但各闭源平台间并不互通，促使“数据孤岛”变成“技术孤岛”。而相对于不同厂商间技术路线的各自为政，基于开源框架的互联互通将更有利于隐私计算产业生态的形成。也因此，开源隐私计算技术框架成为降低企业隐私计算技术研发成本，打破“技术孤岛”，实现跨平台互联互通，推动数据要素流通重要且有效的途径。

* 区块链技术以其去中心化、多方共享、可扩展等特点，使得该领域绝大多数项目都是开源的，近年来，开源也不断赋能区块链领域的技术创新，取得更快发展。国内使用较多的开源区块链项目包括：复杂美研发的区块链底层开发平台Chain33、中国首个区块链软硬件技术体系长安链及技术平台ChainMaker、金链盟开源工作组协作打造的企业级金融联盟链底层平台FISCO BCOS、京东区块链框架JD Chain以及百度区块链底层技术XuperChain等。

* 作为智能制造、工业互联网的核心内容，工业软件已渗透并应用到工业领域的几乎所有核心环节，而近年来工业软件与开源的结合有力冲击了原先关键技术的垄断，为我国实现弯道超车提供了可能。在研发设计类软件、生产控制类软件、业务管理类软件和工业数据软件中，均涌现出了大量开源软件，包括清华数为物联网数据库IoTDB、海尔卡奥斯COSMOPlat工业互联网平台等。

**四、开源社区正在崛起，但运营和治理还处于初级阶段**

过去20年间，开源运动从早期以“Linux操作系统、桌面办公软件（GNOME、OpenOffice）和浏览器（Mozilla）”为主的开源项目，逐渐延伸到数据库、中间件、前后端、物联网、微服务、大数据、人工智能等方向，再到如今的移动互联网、云计算等领域，随之崛起的开源社区也从单一的用户参与逐渐演变为联盟、基金会、行业联盟、组织。据中国开源软件联盟不完全统计，截至2022年3月，国内各类开源社区已经超过500个。

其中，聚焦特定开源项目的项目型社区代表有openEuler、OpenAnolis龙蜥社区、OpenHarmony、深度、RT-thread、Ubuntu Kylin、OceanBase等；以知识分享、经验交流和传播开源文化为主要目标的用户型社区包含LinuxFans、GoCN、Python中国、物联网自动化社区iot.cechina、Linux人社区等；集开源代码、项目孵化、开源治理、媒体等多种功能于一体的服务型社区有GitCode、Gitee、鹏城汇智、GitLink、Coding、木兰开源社区、OpenI启智等。

当前国内开源社区的运营和治理能力大部分还处于比较初级的阶段。形式上具备国外开源社区的治理架构，但还没有真正发挥出开源开放和协作的效应，社区贡献还是主要来源于项目的发起方。此外，在中美科技竞争加剧的大背景下，中国开发者及用户可能面临被断供的风险。因此，持续加强、加大建设中国的代码托管及服务型社区平台，是中国开源发展的首要基础设施。

**五、开源组织及生态高速发展，越来越多的开源组织在生态建设过程中发挥着积极作用**

除开源基金会外，我国的开源组织大致可分为综合型产业联盟、专业型开源组织，地区型开源组织、开源推广型社会组织这四类。在国家政策进一步利好的背景下，越来越多的第三方开源组织开始涌现，据中国民政部的全国社会组织信用信息公示平台（xxgs.chinanpo.mca.gov.cn）资料显示，共有12家从事开源相关工作的社会团体、基金会和民办非企业单位处于正常运营中，其中2020年以后成立的就有7家。此外，海内外各大基金会，也逐渐在中国形成与行业结合的趋势。中国开源生态具有“国内积极布局、开源逐渐渗透行业、开源开发者增速全球第一、开源主题活动激增且形式丰富”等特点，越来越多开源社区和组织正在生态建设过程中发挥着积极作用。

中国开源生态的高速发展有四个明显的标志。

第一，在2015-2020年的五年中，中办国办及国务院所属各部委发布的所有政策文件中，共有37项明确涉及到开源技术、开源项目、开源社区、开源标准的政策法规。在2021年全年更有超过十项的国家政策涉及开源，特别是在《中华人民共和国国民经济和社会发展第十四个五年规划和 2035 年远景规划纲要》中，首次将开源列入国家顶层规划，随后国务院各部委先后单独或联合颁布相关的“十四五”期间的行业发展规划、行动计划和发展意见。其中由中央网信办、工信部、科技部等部委联合印发的《关于规范金融业开源技术应用与发展的意见》更是针对金融行业的开源技术发展给予了肯定和支持。各省市政府也在2021年内相继推出多项开源利好政策，北京（6项）和江苏（6项）并列第一。截至2021年底，2021年全国软件产业收入排名前十的省份发布的政策中有51条支持开源软件，其中27条是在《纲要》出台之后发布的，占比超过50%。

第二，中国开源生态中各类开源组织日渐增多，功能定位更加细化。由中国电子标准化研究院牵头成立的“木兰社区”（2019年）先后推出了“木兰宽松许可证”和“木兰公共许可证”。由华为、百度、腾讯等企业发起中国首个开源基金会“开放原子开源基金会”（2020年）已经正式成立。中国科协发起成立的“科创中国”开源创新联合体（2021年）；中国计算机学会发起的CCF开源发展委员会（2021年），北京发起成立的北京开源创新委员会（2021年）、上海市发起的开源信息技术协会（2020年）、深圳市建设的深圳国际开源谷（2020年）。

第三，中国开源生态中相关的技术交流、开源布道、产品推广活动几乎每天都在进行。根据CSDN、InfoQ、活动行等平台的数据显示，线下的各类开源活动近90%集中在北、上、广、深、杭等城市，而线上开源活动参与者的分布则更为平均。

第四，中国开源领域集中涌现出一些优秀作品，表现形式更加多样化。比如，CSDN发起开源英雄 50人访谈、《开源圆桌派》访谈栏目；停刊多年的《程序员》杂志也在2021年复出，以每季刊发《新程序员》的形式传播开源专题技术内容；中国开源软件推进联盟、中国信息通信研究院等多个机构纷纷推出专业的中国开源发展蓝皮书和开源技术白皮书；北京开源创新委员会发起《源桌会》系列开源节目；腾讯公司发起《腾源会》系列开源活动；开源社发布《中国开源年报》和《开源对话》栏目，以及由中国开源推进联盟的陆首群主席策划定期推出的《人工智能跟帖合集》《深度信息技术》系列读物。众多开源作品，正吸引更多开发者进入中国开源生态。

**六、开源教育由来已久，开源开放、共享的特性与教育的目标和特征不谋而合**

近年来，高等院校中普遍从学生、教师自发的开源教育行为转变为院校行为，从高校教师的独立行为转变为与开源社区合作的共建行为。许多高校还利用开源技术构建学校的教学平台、实验平台、在线教育平台、代码托管平台等，既解决了实际问题，又为学生传播了开源文化。一些高校通过与企业建立联合实验室、共建开源技术课程、建立实训基地等方式，促进学生与企业直接对接，为企业提前储备人才。在国内高校发起的开源项目教育实践中，清华大学、北京大学、浙江工业大学分别带来IoTDB、XiUOS、DGIoT-Edu、Kellect等开源项目的教育实践详情介绍，纵览开源教育如何在教学和科研工作中高效展开。在人才培养的高、中、小学阶段，开源文化与技术也逐渐渗入庞大的教学体系中，开源软件作为素质教育、创客教育的工具，培养学生的科学精神和创造力。与此同时，开源职业教育与终身教育跟随行业需求飞速发展。

校企合作模式以北京大学、清华大学等知名985高校的软件学院、计算机学院和腾讯、百度、阿里、滴滴、小米、同方等头部企业为主，但必须指出，在非985高校更应开展校企合作来提升开源教育水平。许多企业主动携手地方政府和高校对开源教育模式创新进行探索，如以企业为主导的“联盟”模式，政府联手的“1+1+1工程”，以校园为基础的“浙江模式”和综合推进的“广州经验”，都提供了宝贵经验。

除了院校教育，开源教育平台也在迅速沉淀。典型的平台包括两类：基于开发工具和知识社区的开源教育平台、基于开放实践和开源竞赛的开源教育平台，包括GitHub、GitCode、Gitee、GitLink、SourceForge、AI Studio、C训练平台、头歌等知名教学和实践平台。

然而，开源教育取得卓著成绩的同时，也存在一些待攻克的难题。其中，开源人才与市场的需求仍然存在较大差距是当下亟需解决的问题。为此，探索多主体开源教育协同模式需要提上日程。“多主体”即由多个主体如企业、高校和科研院所承担开源教育的职责，在多主体的基础上，协同教育模式成为开源教育的主要趋势，由政府引导，高校、企业、社区、科研院所多方积极协同，由多平台提供支持。

当下，开源产业生态高速发展，人才需求紧随其变化，为高校开源人才培养带来匹配难度。同时，多主体开源教育协同、融合机制仍在初级发展阶段，可持续协同模式尚未形成领先经验。对此，2022年3月，全国人大代表、中国科学院院士、南京大学校长吕建在两会期间建议：首先，推动基于优秀开源成果的课程体系设计、师资队伍建设和培养计划制定，培养开源创新人才，支撑开源软件形成可持续发展生态；其次，加强开源文化和开源技能教育，建立鼓励软件成果开源的评价机制和价值导向，推动高校产出更多原创性开源成果；最后，以开源教育为抓手，打造新型产教融合平台，建立从高校开源学习、产业开源实践到开源创新创业的闭环，服务我国软件产业发展。

**七、开源商业：开源项目和开源企业已经成为被资本市场追捧的投资热点领域**

自开源软件脱胎于自由软件开始，对商业友好、与商业共存就被写入开源基因。然而，如何围绕开源技术选择商业模式、如何将开源协作和企业运营结合、如何让开源生态和商业生态融合，一直是全球开源界关注的热点问题。中国开源软件推进联盟也曾多次组织各种调研活动就上述问题展开讨论，单一的使用许可和订阅服务正在逐渐被双授权、捆绑和开放核心等模式替代，作为同类的开源技术的提供者，软件企业、硬件企业、集成商、运营商甚至广告商，可采用不同的商业模式。

目前，开源商业化在国际市场取得了较大的突破，实现了10倍速的增长。开源产品的优越性也得到了更好的验证，落地生花。我们正处在开源产业发展最好的机遇期，能够看到非常多的开源初创项目和企业正在快速发展和成长。做开源项目，一定要有全球化的视野。通过开源，全世界的用户和开发者都可以触达到，这是一个巨大的机会。

* 收入过1亿美金的开源公司有了爆发性的增长，从过去只有屈指可数的几家如今已迅速增长至五十余家。
* 从以红帽、IBM为代表的支持和服务模式、MongoDB等的商业版本到Open Core和基于开源的商业产品，开源的商业模式经历了三代演进，逐渐成熟。而Open Core和基于开源的商业产品加上云原生（Cloud Native），正是开源商业化大爆发最为重要的内在因素，这一组合也成为了当前开源商业公司采用的主要模式。
* 目前中国开源正在被资本投资者重点关注。主要原因包括：1）开源模式成为国家支持的重点科技创新路径。2）基于开源的“卡脖子”技术成为国家投资的重点方向。3）当代开源创业者比以往更加关注全球市场，更加重视构建商业价值。4）源自基金会的开源项目在技术合规、成熟度以及品牌上有一定基础。5）开源是更为高效的研发模式，更加高效的获客。6）开源商业模式日臻成熟，项目或企业发展轨迹有迹可循。
* 在中国市场，随着数字化时代的到来，中国迎来了开源创业的浪潮，开源也正在被资本投资者重点关注。据CSDN关于中国开源项目融资的数据统计显示，在2020年11月至2022年2月间，国内33家开源企业总计获得超过人民币70亿元。在2021年，开源融资较2020年实现了几乎翻倍的增长。而从融资分布的技术领域来看，主要集中在数据库、云原生和人工智能上。
* 开源赋予了用户永远选择的权利，对于一个基于开源项目的商业公司而言，未来的竞争力不应仅仅停留在代码层面，而是基于代码和面向特定用户服务的能力，构建起开发者和用户的生态，由此形成竞争壁垒。

## 中国开源发展的机遇与挑战

近年来，中国经济发展中“大”、“快”、“全”的特点投射到中国开源领域，帮助中国成为全球开源市场新的增长点。

所谓“大”，是指中国市场的规模大。许多开源技术进入中国市场后，得益于规模化效应，找到了自身的商业模式，实现了快速发展。“全”指的是产业生态全。中国具备全球最完善的电子制造业产业生态，许多开源技术在这里找到载体落地最终销往全球各地，这种虹吸效应正在吸引越来越多的开源企业加入中国完善的产业链，成为其中一部分，帮助中国开源形成一个产业高地。所谓“快”，指的是中国惊人的发展速度。中国的移动互联网和云计算飞速发展，开源技术可以帮助很多中小企业先试先行，通过快速部署收到海量反馈，进而快速迭代产品，帮助开源技术走向成熟，实现商业化。

中国开源所处的加速发展阶段，也使开源呈现出与各技术领域如数据库、人工智能、云计算等深度融合趋势，以及向传统行业如金融、电信、医疗、制造业等快速渗透的特点。中国开源未来三至五年有能力孕育出五家或更多市值百亿的新头部企业。如果一个项目具备开源基因、具备国际化视野、具备清晰商业模式、具备活跃的开源社区和持续增长的技术粉丝群，一定会受到资本市场的追捧。尤其是芯片、操作系统、人工智能，或从属于这些领域，是所谓的“卡脖子”技术的一部分，或者是面向工业互联网、智能网联汽车、元宇宙等重点发展方向。

## 开源发展的机遇

**机遇一：中国的产业链优势是开源发展的历史机遇**

移动互联网与云计算在中国的快速发展，吸引了全球范围内的开源项目进入中国市场，极大的市场容量促使以云原生为代表的新型订阅收费模式快速变现。而吸引众多全球开发者的另一个因素，是国内大型企业将其产品陆续开源以及大量以开源为基础的初创公司开始涌现。此外，中国具备全球最完善的电子工业产业链，许多开源技术在中国市场找到载体落地最终销往全球。开源技术本地化，并在本地提供服务和二次开发的过程，是一个明显的趋势，并且该过程会降低开源在中国产业生态内的应用和产业化门槛并加速产业化进度。

**机遇二：传统行业积极拥抱开源、引入开源软件**

开源在各行业的渗透率正在逐渐加深。传统行业业务发展导致企业需要考虑持续变化的业务需求响应能力、软件性能及成本与效率。出于传统行业的增长需求、市场环境的变化、客户需求的多样性等原因，传统企业自身的研发能力不足以支撑企业敏捷响应、快速迭代、开发，制约了企业的快速发展。在此背景下，开源由于其开放式协作的特点，使得开发流程更为敏捷，业务需求和变化能快速得到响应，而且开源社区为企业与外部精英提供合作平台，可以解决短期内传统行业研发实力不足的问题。引入开源软件意味着企业可以基于原有开源代码自行开发或只需采购增量服务，节约时间、人力、经济成本的同时，提升了企业业务竞争力，驱动了企业数字化转型和新的增长机遇。

据红帽发布的《2021全球企业开源现状》报告显示，当前已经有超过90%的IT领导者都在使用企业级开源。同时据数据统计，2020年全球财富50强中，72%的企业在使用GitHub平台托管代码，国内超过八成的行业客户都在软件开发生产中使用到了开源技术。开源渗透行业同时，行业也在反哺开源，其中尤以金融和电信行业为甚，近年来涌现了诸多非常优秀的开源项目。例如，微众银行已发起二十余个开源项目，其中两个已于2021年进入Apache孵化器。以中国移动为代表的中国运营商与海外企业合作，参与推动了包括ONAP、Edge、G-SRv6等基于平台、关键部件、系统与集成领域的开源项目。

可以预见，行业正在逐渐形成拥抱开源、使用开源的共识。根据主要开源供应商向CSDN提供的来自19个不同行业的156个企业案例中，金融业、运营商以及政务、医疗行业的案例占比最高。在开源社区建设方面，金融、电信、制造业等传统行业也已经形成行业特色。行业开源社区主要承担行业内的开源代码服务、供需对接、行业开源治理推动、开源规范制定、企业交流及开源生态建设等角色，极大地推动了各行业开源协作和开源实践。

**机遇三：开源与各技术领域深度融合**

* 在数据库领域，开源展现出两大趋势。一是商业数据库逐渐走向开源；二是中国在分布式、实时数仓等方向的开源产品已经成为了全球范围内的优秀项目。
* 在人工智能领域，深度学习已经是技术创新与开源落地的主要方向。
* 在物联网领域，开源在智能网联汽车中表现出的应用机遇尤为显著。汽车软件会变成一个由开源和专有组件组成的生态系统，共同提供软件组件的可选择性和灵活性，采用敏捷的软件开发、发布。对于主流汽车厂商，使用开源软件的前景将具有巨大的吸引力，因为它保留了对全栈软件的控制权，包括他们的数据。中国是世界最大的汽车产销国，且是新能源汽车的旗手，在软件定义汽车时代，被誉为母生态的智能网联汽车领域，已经成为企业竞相布局的重点。
* 在元宇宙领域，由GitHub社区数据可知，2021年第三季度新建的元宇宙开源项目数量为102个，同比增长827%，环比增长252%，元宇宙携手开源可谓来势汹汹。开源世界是建立元宇宙的首选之地，其具备构建元宇宙所需要的所有内容和软件，而且完全免费。开源是元宇宙成为公共可信生存空间的必然前提。

## 开源面临的挑战

**一、技术风险长期存在**

开源软件漏洞数量保持高位，且影响范围巨大，同时需要探索如何确保上游组件的修复快速、大规模、全覆盖地推送到下游依赖环节。据奇安信代码安全实验室《2021中国软件供应链安全分析报告》显示，截至2020年底，CVE/NVD、CNNVD、CNVD等公开漏洞库中共收录开源软件相关漏洞41342个，其中5366个为2020年度新增漏洞。而在奇安信代码安全实验室审计的2557个国内企业软件项目中，存在已知开源软件漏洞的项目有2280个，占比高达89.2%；存在已知高危开源软件漏洞的项目有2062个，占比为80.6%；存在已知超危开源软件漏洞的项目有1802个，占比为70.5%。

2021年12月10日Apache Log4j2被发现其某些功能存在递归解析功能，存在攻击者可直接构造恶意请求，触发远程代码执行的漏洞。根据工信部发布的《关于阿帕奇Log4j2组件重大安全漏洞的网络安全风险提示》，该漏洞可能导致设备远程受控，进而引发敏感信息窃取、设备服务中断等严重危害，属于高危漏洞。据不完全统计，GitHub 超过8600多个开源软件直接依赖log4j2组件，但通过这些开源软件继续追溯，最终超过20万个开源软件受到了影响。同时，在官方第一次发布修复版本的一周时间后，仍然有超过80%的间接关联开源软件没有被修复。

**二、法律风险日益突出**

法律风险表现在开源许可证法律效力有待进一步明确，著作权边界纵横交织，专利权体系复杂，商业秘密判断困难等方面。

* 许多热门项目的责任方都因为许可证定义含糊不清而删除了使用JSON许可证的代码，因为“善意用途”与“恶意用途”定义争议性极强，很难界定。
* 开源代码有时候会渗透到其他代码中，或者其他代码渗透到开源代码中。根据不同的开源许可，则有可能不得不向整个社区公开原本不想公开的代码。
* 专利在申请阶段就需要提交和申请很多文件，而一旦出现潜在的侵权问题，专利的诉讼成本也高于一般的著作权诉讼的成本。
* 开源软件本身就开放了很多信息，哪部分能够构成商业秘密，未来尚需探讨。

**三、开源供应链日趋庞杂，关键开源组件的可持续维护面临挑战**

开源软件的长期义务维护可能会导致一系列不公平的现象，例如商业公司通过开源软件赚取了丰厚利润，但并没有给维护者任何回馈，甚至会刻意回避谈及对开源软件的使用，由此引起开源维护者的反感甚至一些过激行为。

如今，国际局势动荡，凸显开源组织（如基金会）、开源代码托管平台（属于商业公司所有）都会受到属地出口管制政策的制约。最近几年，开源软件供应链出现了意识形态、地缘政治、战争冲突等导致的开源社区分裂。一些关键的开源托管平台和开源基础软件对特定国家、特定实体雇员采取了账号禁止访问、代码删除等“断供”行为，这也是未来开源软件发展面临的又一巨大挑战。

此外，大企业垄断开源生态阻碍了创新。一方面因大公司拥有在更高级别上开发和维护开源项目所需的资金，推动产生了更多的开源重点项目，并有助于提高质量和安全性；另一方面，受商业利益等因素驱使，通过对开源社区项目的开发和商业化推广，对开发人员施加种种限制，易造成技术垄断，并最终阻碍技术创新。

**四、开源人才的问题也比较突出**

人才危机表现在三方面：人才供需对接的效率低；高技能人才匮乏，顶尖开源人才难寻；企业对开源人才的培养成本投入少，开源人才留存困难。据GitHub《2021年度Octoverse报告》统计，中国开发者人数占比排名第二，有755万+。按照中国数字经济转型发展的要求，2022年中国有1200万的人才需求缺口。但企业找到恰当的、需要的人才成本依然很高，普通大学毕业生去企业之后要1-2年才能适应开源等工作的岗位要求，总体来看，人才培养周期长，加剧了企业的开源人才挑战。

开源社在《2021年开源工作报告》中指出，组织对顶级开源人才的需求已大于以往任何时候。在吸引顶尖人才方面，我国依然缺乏竞争力，高层技术专家和人才严重匮乏尤其明显。目前我国技能劳动者已经超过2亿，高技能人才仅占技能人才总量的28%，这个数据与发达国家普遍40%以上的数据相比，仍然存在很大差距。同时，由于工作时间长、压力大、企业凝聚力弱等问题，给开源人才的留存造成了一定困难。加之多数企业存在人力成本居高不下，对开源人才的支持与培养投入少，导致在开源人才管理方面也面临挑战。

## 中国开源发展建议

**一、加强重点开源人才培养，推动开源教育和价值引导**

* 加强中国本土开源开发者人才的培养。据2021年数据分析，来自中国开发者社区CSDN用户数为3500万，而Github显示中国开发者仅为755万，这说明大量的中国开发者并不能加入到英文化的国际开源社区中，因此培养本土开源人才，为他们提供专业、高质量、系统性的学习教程、开发工具及资源，通过学、练、用、创，加快中国本土开源人才培养的规模化进程。
* 推动开源成果在高校及业界的课程与认证体系设计、师资队伍建设和培养计划，培养开源创新人才，支撑开源软件形成可持续发展生态；以开源教育为抓手，打造新型产教融合平台，建立从高校开源学习、产业开源实践到开源创新创业的闭环；通过企业和高校的紧密合作，将开源生产环境与教学环境融合，成规模的为开源产业提供高水准的开源软件开发者。
* 加强开源文化和开源技能教育，建立鼓励开源成果的评价机制和价值导向，加大政策引导和宣传推广，激励和推动科研院所、高校及工业界产出更多原创性的开源成果。
* 吸引和鼓励更多专业型人才进入开源体系。开源所需要的专业人才包括技术开发、开源运营、法务、企业关系等专业领域，而这些稀缺型的专业人才又多集中在头部的IT和互联网公司，如何吸引来自产业界和开源社区具有丰富实践经验的一线开源专家和优秀人才、并形成稳定的人才培养体系，是真正影响开源产业规模化的关键力量。
* 加强国际顶级开源人才交流，推动中国开源人才高地建设。2006年，中国开源推进联盟COPU聘请世界著名的开源领袖和大师担任COPU智囊团高级顾问。首届智囊团人员20人，此后发展到40多人，这是COPU创建的开源高地，伴随中国开源向更高阶段发展，持续建设高端开源人才、开源智囊团，加强国际开源组织的合作与融入，意义将更为重要和深远。

**二、推动开源开发者及社区建设，强大开源基础动力**

* 鼓励开发者和开发者社区普及开源文化、倡导开源精神，参与开源、贡献开源。增强开发者对开源领域问题的研判及引领能力，积极引导和提升开发者的开源专业能力，推动中国开源开发者的成长与贡献，为中国开源提供持续动力。
* 打造良好开源生态的重中之重，就是建好开发者社区。加强本土开源社区和开源代码托管平台的建设，通过本地化使用体验的开源项目平台和开源知识库，降低国内开发者对语言沟通、开源文化、国际社区规则和管理机制的高门槛要求，为中国开源发展提供基础性支撑。
* 业界需要高效协同，加大开源布道、加强软件合规的普及。加深对开源社区治理的研究，提高开源社区和开源项目的治理和运营能力，为开源社区治理专家、开源项目核心维护人员提供定向资助，让有实力有经验的专业人员，持续的专注于开源社区和项目的发展。
* 持续加强中国开源基金会及开源组织建设，坚守并践行中立原则的开源基金会与开源组织将赢得开发者以及合作企业的持久信赖。

**三、大力扶持优秀开源项目，推动开源商业化及生态发展**

* 构建良好的开源软件生态，得生态者得天下。发布开源的根项目，发挥中国市场和高端软件人才的优势，引导市场主体和开源开发者拥抱开源软件，让更多优质开源项目在中国诞生，形成良好生态，并走向世界。
* 开源商业化问题是中国开源项目的难题，我国自发的开源企业需要建立稳定的开源商业模式，一是针对国际基金会顶级开源项目，建立社区反馈和联动机制：二是建立开源生态，重点在操作系统、数据库、中间件等基础软件领域探索开源发展。三是在热门融资赛道，如云原生、AI、数据技术、物联网、元宇宙等领域，与传统行业及数字化应用相结合，打造出稳定的商业化路径。
* 继续完善第三方开源运营机制：一是国内开源联盟/组织持续推进与企业的开源运营合作，借助联盟标准化与行业推广优势，推动我国自发开源项目应用；二是开源基金会形成稳定的决策机制，项目孵化流程，为国内开源项目运营提供有力知识产权、托管、孵化以及法律、协作支撑。

**四、加强行业标准与规范，解决安全隐患与供应链风险**

* 培养开源软件供应链安全人才。建设开源供应链安全运维团队，建立关键供应链所涉及的各行业/企业内部成立一支高素质的维护团队。大力培养开源供应链安全管理、技术与战略人才，从战略、战术上给予重点培育培养。
* 构建开源供应链安全评估体系。扶持一批从事开源软件安全评估的创新企业，打造开源供应链的安全评估体系。从开发者个人、企业发展、开源组织、国家政策等五个维度构建开源供应链安全评估框架，制定开源供应链安全行为准则，实时监测国内开源供应链的重点事件。
* 建立开源供应链安全实验室。打通个人开发者、企业、政府管理部门三者之间的旋转门机制，鼓励企业的一线开源开发者到政府管理部门工作，同时允许政府管理人员到开源企业从事管理与战略工作。
* 在上游开源软件和开源社区的基础上，由具有社会公信力的机构，牵头打造开源软件供应链基础设施，形成公共服务能力，为千行百业提供高质量、可持续的开源软件供应。

## 中国开源的发展，未来可期！
今天，软件已经吞噬了世界，而开源正在吞噬软件。我们可以看到，几乎每一家大型科技公司都是基于开源软件建立起来的，而且，这样的公司越来越多。未来，这一良性循环将持续发酵，开源软件将进一步扩展我们的思维方式并定义新的开源商业。开源市场及其可能性，远远超过我们过去的认知。
我们的世界正处于百年不遇的大变局，全球政治、经济、金融、军事、科技正在重构，但2019年中期以来，美西方对我国高科技产业和高科技骨干企业实行封锁、打压、断供，这股恶潮也波及到开源界。
但开源追求的开放、共享、平等、自由和多元化，是所有开源人的共识。中国开源必须坚持战略定力，坚守战略耐心，坚持在开放环境下自主创新，坚持与西方真正开源的机构或同仁合作，以聚四海之气，借八方之力，变“危”为“机”。
